'use strict';

function UserTokenModalCtrl($scope, $rootScope, $http){
    $scope.sentTokensSuccess = true;

    $scope.$on('Groups:openUserTokensWindow', function(event, user){
        $scope.openModal();
        $scope.user = user;
        $scope.user.loadTokens();
    });

    $scope.openModal = function(){
        angular.element('#modal-token').modal('show');
    }

    $scope.closeModal = function(){
        angular.element('#modal-token').modal('hide');
    }

    $scope.openSentTokensModal = function(){
        angular.element('#modal-sent-tokens').modal('show');
    }

    $scope.closeSentTokensModal = function(){
        angular.element('#modal-sent-tokens').modal('hide');
    }

    $scope.generateNewList = function(){
        $scope.user.generateNewTokensList();
    }

    $scope.print = function(){
        angular.element('.print').html(angular.element('#tokens-list').html());
        window.print();
    }


    $scope.sendMail = function(){
        var message = {
            title: 'Tokeny'
            ,msg: 'Trwa wysyłanie tokenów. Proszę czekać...'
        }

        $rootScope.$broadcast('Message:addMsg', message);

        $http.get(appDev + '/admin/api/user/tokens/send/' + $scope.user.id)
            .success(function(data){
                $rootScope.$broadcast('Message:delMsg', message);
                $scope.sentTokensSuccess = true;
                $scope.openSentTokensModal();
            })
            .error(function(data){
                $rootScope.$broadcast('Message:delMsg', message);
                $scope.sentTokensSuccess = false;
                $scope.openSentTokensModal();
            })
        ;
    }
}

UserTokenModalCtrl.$inject = ['$scope', '$rootScope', '$http'];